CREATE OR REPLACE FUNCTION sp_ReadTreeNode ()
RETURNS TABLE(id VARCHAR, text VARCHAR, type TEXT, icon INT, ParentGuid VARCHAR) AS $BODY$
DECLARE
    root VARCHAR;
    localFolder VARCHAR;
    unmanagedFolder VARCHAR;
BEGIN

SELECT guid INTO root FROM tb_system_node WHERE type_=1;
SELECT guid INTO localFolder FROM tb_system_node WHERE type_=2;
SELECT guid INTO unmanagedFolder FROM tb_system_node WHERE type_=3;

RETURN QUERY
SELECT guid AS id
     , display_name AS text
     , CASE WHEN guid=root THEN 'root'
            WHEN guid=localFolder THEN '1'
            WHEN guid=unmanagedFolder THEN '1'
            WHEN type_=1 THEN '1'
            ELSE '2'
       END AS type
     , CASE WHEN product_type IS NULL THEN 0
            ELSE product_type
       END AS icon
     , parent_guid AS ParentGuid
FROM "tb_tree_node";

END

$BODY$ LANGUAGE plpgsql;
